#这里用于实现蓝图功能 
#首先引入蓝图
from flask_dianshang1_0.user import user_bp,user_api
from flask_dianshang1_0.modules import User
from flask_dianshang1_0 import modules,db
from flask import request
from flask_restful import Resource
import re
from flask_dianshang1_0.token import creat_token,check_token
from werkzeug.security import generate_password_hash


@user_bp.route('/',methods=['GET'])
def hello():
    return "hello user"


#登录接口
@user_bp.route("/login",methods=['POST','GET'])
def login():
    #username = request.form.get("username")  #这个方法适用于Content-type:application/x-www-form-urlencoded
    data = request.get_json()
    username = data.get("username")
    pwd = data.get("password")
    if not all([username, pwd]):
        return {"status": 500, "msg": "缺少必要的参数"}
    user = User.query.filter_by(name=username).first()
    if user:
        if user.check_password(pwd):
            token = creat_token({"username": username})
            return {'status': 200, 'msg': "登录成功", 'data': {'token': token}}
        else:
            return {'status': 500, 'msg': "用户密码错误"}
    else:
        return {'status': 500, 'msg': "用户信息不存在，请先注册"}


# 注册功能
class UsersReg(Resource):
    def get(self):
        pass

    def post(self):
        #注册功能   接收所需要的参数
        username = request.get_json().get("username")
        pwd = request.get_json().get("password")
        re_pwd = request.get_json().get("re_pwd")
        nick_name = request.get_json().get("nickname")
        phone = request.get_json().get("phone")
        email = request.get_json().get("email")
        # 进行逻辑判断
        if not all([username,pwd,re_pwd,nick_name]):
            return {'status':500,'msg':"参数不完全"}
        else:
             #参数齐全 进行其他判断           
            user = User.query.filter_by(name=username).first()
            if user:
                return {'status':500,'msg':"用户名已存在"}
            if pwd != re_pwd:
                return {'status':500,'msg':"两次输入的密码不一致"}
            if not re.match(r'^1[3456789]\d{9}$', phone):
                return {'status': 500, 'msg': '手机号不合法'}
            if not re.match('^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+$', email):
                return {'status': 500, 'msg': '请输入正确的邮箱'}
            #逻辑判断都符合之后创建user对象并且写入到数据库中
            user = User(name=username, password=pwd, nick_name=nick_name, email=email, phone=phone)
            db.session.add(user)
            db.session.commit()
            return {'status': 200, 'msg': '注册成功'}
        


# 把注册接口加入到api中
user_api.add_resource(UsersReg,"/reg")
        