from flask_dianshang1_0 import db
from datetime import datetime
from werkzeug.security import generate_password_hash, check_password_hash
class BaseModel(object):
    creat_time = db.Column(db.DateTime,default=datetime.now)
    updata_time = db.Column(db.DateTime,default=datetime.now,onupdate=datetime.now)



class User(db.Model,BaseModel):
    __tablename__ = 't_users'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    name = db.Column(db.String(32), unique=True,nullable=False)
    pwd = db.Column(db.String(128))
    nick_name = db.Column(db.String(32))
    phone = db.Column(db.String(11))
    email = db.Column(db.String(32))

    @property
    def password(self):
        #通过property修饰器定义一个paswword属性 当访问password属性的时候会自动返回pwd数据
        return self.pwd
    
    @password.setter
    def password(self,pwd):
        print(f"传进来的pwd{pwd}")
        self.pwd = generate_password_hash(pwd)   #通过generate_password_hash方法 将闯进来的pwd值进行加密 并赋值给数据库对象的pwd
        print(f"获取到的self{self.pwd}")
    
    def check_password(self,pwd):
        print(self.pwd,pwd)
        return check_password_hash(self.pwd, pwd)