from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from config import Config_Map
#创建一个数据库对象
db = SQLAlchemy()

def creat_app(Config_name):
    #创建app的应用
    app = Flask(__name__)
    #通过传入的参数获取config对象
    Config = Config_Map.get(Config_name)
    #加载app的配置
    app.config.from_object(Config)
    #以下代码设置返回中文
    app.json.ensure_ascii = False
    # 初始化db对象
    db.init_app(app)
    #返回app对象
    return app
