import os

#设置config
class Config:
    MYSQL_DIALECT = 'mysql'
    MYSQL_DRIVER = 'pymysql'
    MYSQL_USERNAME = 'root'
    MYSQL_PASSWORD = ''
    MYSQL_HOST = 'localhost'
    MYSQL_PORT = 3306
    MYSQL_DB = 'flask_shop'
    MYSQL_CHARSET = 'utf8mb4'
      # 数据库链接字符串URI
    SQLALCHEMY_DATABASE_URI = f'{MYSQL_DIALECT}+{MYSQL_DRIVER}://{MYSQL_USERNAME}:{MYSQL_PASSWORD}@{MYSQL_HOST}:{MYSQL_PORT}/{MYSQL_DB}?charset={MYSQL_CHARSET}'
  # 数据盐
    SECRET_KEY = os.urandom(16)
    DEBUG = True
    RESTFUL_JSON = {'ensure_ascii':False}


#开发环境下返回的config
class DevelopmentConfig(Config):
    DEBUG = True

#生产环境下的返回的config  
class ProductConfig(Config):
    DEBUG = False

#用户环境下返回的config
class TestConfig(Config):
    pass

Config_Map = {
    "product":ProductConfig,
    "development":DevelopmentConfig,
    "test":TestConfig
}