package com.plan_game;
import java.awt.*;
import java.awt.event.*;
import java.util.Date;

public class MygameFram extends Frame {
    Image planeimg =Gameutill.getImage("Images/plane.jpeg");
    Image bglmg =Gameutill.getImage("Images/Beij.jpeg");
    Plan plan =new Plan(planeimg,300,300,15);
    Shell[] shells =new Shell[30];
    Explode explode ;
    Date starTime =new Date();
    Date endTime ;
    int period;
    public void lauchFrame() {
        this.setTitle("本帅的飞机大战开始了");
        this.setVisible(true);//显示窗口,默认不可见
        this.setSize(Gameutill.WIDTH_SS, Gameutill.HEIGHT_SS);//窗口大小
        this.setLocation(600, 300);//位置
        new PaintThread().start();//启动重画线程
        for(int i = 0; i < shells.length; i++) {
            shells[i] =new Shell();
        }
        this.addKeyListener(new keyMonitor());//添加键盘监听
        this.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
    //打印信息
    public void printInfo(Graphics g,String str ,int size,int x,int y,Color color){
        Font oldFont =g.getFont();
        Color oldColor =g.getColor();
        Font f=new Font("宋体",Font.BOLD,size);
        g.setFont(f);
        g.setColor(color);
        g.drawString(str,x,y);
        g.setFont(oldFont);
        g.setColor(oldColor);
    }
    public void paint(Graphics g){
//        System.out.println("窗口被绘制了");
        g.drawImage(bglmg,0,0,Gameutill.WIDTH_SS,Gameutill.HEIGHT_SS ,null);
        plan.drawMyself(g);
        for (int i = 0; i < shells.length; i++){
            if (shells[0] != null){
                shells[i].drawMyself(g);
                boolean b=shells[i].getRec().intersects(plan.getRec());
                if (b&&plan.live){
                    endTime =new Date();
                    plan.live = false;
//                    int period =  (int)(endTime.getTime()-starTime.getTime()/1000);
                    period = (int)((endTime.getTime()-starTime.getTime())/1000);
                    if (explode== null){
                        explode =new Explode(plan.x,plan.y);
                    }
                    explode.draw(g);
                }
            }

        }
        if(!plan.live){
            printInfo(g,"牢大坠机了,牢大坚持了"+period+"秒",25,150,200,Color.PINK);
        }
    }
    //添加键盘监听:
    class keyMonitor extends KeyAdapter{
        public void keyPressed(KeyEvent e){
            plan.Addmove(e);
//            System.out.println("按下"+e.getKeyCode());
        }
        public void keyReleased(KeyEvent e){
            plan.MinMove(e);
//            System.out.println("松开"+e.getKeyCode());
        }
    }
    //重画线程
    class PaintThread  extends Thread{
        @Override
        public void run() {
            while(true){
                repaint();//重绘
                try {
                    Thread.sleep(40);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
    private Image offScreenImage = null;

    public void update(Graphics g) {
        if (offScreenImage == null)
            offScreenImage = this.createImage(Gameutill.WIDTH_SS, Gameutill.HEIGHT_SS);

        Graphics gOff = offScreenImage.getGraphics();
        paint(gOff);
        g.drawImage(offScreenImage, 0, 0, null);
    }
    public static void main (String[]args){
            MygameFram game = new MygameFram();
            game.lauchFrame();
        }
}




















