from time import sleep

import random

import pygame

# 设置通用属性
BG_COLOR = pygame.Color(0,0,0)
screen_width = 800
screen_height = 600
text_color = pygame.Color(255, 0, 0)


class Tank:
    """
    坦克类
    """

    def __init__(self, left: int, top: int) -> None:
        self.images = {
            "U": pygame.image.load('./img/p1tankU.gif'),
            "D": pygame.image.load('./img/p1tankD.gif'),
            "L": pygame.image.load('./img/p1tankL.gif'),
            "R": pygame.image.load('./img/p1tankR.gif')
        }
        # 设置我方坦克的方向
        self.direction = 'U'
        # 获取图片信息
        self.image = self.images.get(self.direction)
        # 获取图片的矩形
        self.rect = self.image.get_rect()
        # 设置我方坦克位置
        self.rect.left = left
        self.rect.top = top
        # 设置坦克移动速度
        self.speed = 10
        # 设置移动开关
        self.remove = False

    def display_tank(self) -> None:
        """
        显示坦克
        """
        # 获取最新坦克的朝向位置图片
        self.image = self.images.get(self.direction)
        MainGame.window.blit(self.image, self.rect)

    def move(self) -> None:
        """
        坦克的移动
        """
        if self.direction == "L":
            # 判断坦克位置是否在左边界
            if self.rect.left > 0:
                self.rect.left = self.rect.left - self.speed
        elif self.direction == "R":
            # 判断坦克位置是否在右边界
            if self.rect.left + self.rect.width < screen_width:
                self.rect.left = self.rect.left + self.speed
        elif self.direction == "U":
            # 判断坦克位置是否在上边界
            if self.rect.top > 0:
                self.rect.top = self.rect.top - self.speed
        elif self.direction == "D":
            # 判断坦克位置是否在下边界
            if self.rect.top + self.rect.height < screen_height:
                self.rect.top = self.rect.top + self.speed

    def shot(self) -> None:
        """
        坦克的射击
        """
        pass


class MyTank(Tank):
    """
    我方坦克类
    """

    def __init__(self):
        pass


class EnemyTank(Tank):
    """
    敌方坦克类
    """

    def __init__(self, left, top, speed) -> None:
        # 加载敌方坦克图片
        self.images = {
            "U": pygame.image.load('./img/enemy1U.gif'),
            "D": pygame.image.load('./img/enemy1D.gif'),
            "L": pygame.image.load('./img/enemy1L.gif'),
            "R": pygame.image.load('./img/enemy1R.gif')
        }
        # 设置敌方坦克方向
        self.direction = self.rand_direction()
        # 获取图片信息
        self.image = self.images.get(self.direction)
        # 获取图片的矩形
        self.rect = self.image.get_rect()
        # 设置敌方坦克位置
        self.rect.left = left
        self.rect.top = top
        # 设置敌方坦克移动速度
        self.speed = speed

    def rand_direction(self) -> str:
        """
        随机生成方向
        """
        chice = random.randint(1, 4)
        if chice == 1:
            return "U"
        elif chice == 2:
            return "D"
        elif chice == 3:
            return "L"
        elif chice == 4:
            return "R"


class Bullet:
    """
    子弹类
    """

    def __init__(self):
        pass

    def display_bullet(self) -> None:
        """
        显示子弹
        """
        pass

    def move_bullet(self) -> None:
        """
        子弹的移动
        """
        pass


class Wall:
    """
    墙壁类
    """

    def __init__(self):
        pass

    def display_wall(self):
        """
        显示墙壁
        """
        pass


class Explode:
    """
    爆炸类
    """

    def __init__(self):
        pass

    def display_wall(self):
        """
        显示爆炸效果
        """
        pass


class Music:
    """
    音效类
    """

    def __init__(self):
        pass

    def play_music(self):
        """
        播放音效
        """
        pass


class MainGame:
    """
    游戏主窗口类
    """
    # 游戏主窗口对象
    window = None
    # 设置我方坦克
    my_tank = None
    # 存储敌方坦克列表
    enemy_tank_list = []
    # 设置敌方坦克数量
    enemy_tank_count = 6

    def __init__(self) -> None:
        pass

    def start_game(self) -> None:
        """
        开始游戏
        """
        pygame.display.init()  # 初始化窗口
        MainGame.window = pygame.display.set_mode((screen_width, screen_height))  # 创建窗口
        pygame.display.set_caption("坦克大战1.0")  # 设置窗口标题
        # 创建我方坦克
        MainGame.my_tank = Tank(350, 200)
        # 创建敌方坦克
        self.create_enemy_tank()
        while True:
            sleep(0.05)
            MainGame.window.fill(BG_COLOR)
            num = 5
            text = self.get_text_surface(f'地方坦克剩余数量{num}')
            MainGame.window.blit(text, (10, 10))
            # 增加事件
            self.get_event()
            # 显示我方坦克
            MainGame.my_tank.display_tank()
            # 显示敌方坦克
            self.display_enemy_tank()
            # 控制坦克移动
            if MainGame.my_tank.remove:
                MainGame.my_tank.move()
            pygame.display.update()
        # sleep(2)

    def create_enemy_tank(self):
        """
        创建敌方坦克
        """
        self.enemy_top = 100
        self.enemy_speed = 10
        for i in range(self.enemy_tank_count):
            # 生成坦克的位置
            left = random.randint(0, 600)
            # 创建敌方坦克
            e_tank = EnemyTank(left, self.enemy_top, self.enemy_speed)
            # 将敌方坦克添加到列表中
            self.enemy_tank_list.append(e_tank)

    def display_enemy_tank(self):
        """
        显示敌方坦克
        """
        for e_tank in self.enemy_tank_list:
            e_tank.dispaly_tank()

    # 添加提示文字
    def get_text_surface(self, text: str):
        """
        获取文字的图片
        """
        pygame.font.init( )  # 初始化字体模块
        font = pygame.font.SysFont('kaiti', 18)  # 创建字体
        text_surface = font.render(text, True, text_color)  # 绘制文字信息
        return text_surface  # 将绘制的文字信息返回

    def get_event(self):
        """
        获取事件
        """
        event_list = pygame.event.get( )  # 获取事件列表
        # 遍历事件
        for event in event_list:
            # 判断是什么事件，然后做出相应的处理
            if event.type == pygame.QUIT:
                self.end_game()
            if event.type == pygame.KEYDOWN:
                if event.key == pygame.K_LEFT:
                    print("坦克向左移动")
                    # 修改坦克方向
                    MainGame.my_tank.direction = "L"
                    MainGame.my_tank.remove = True
                elif event.key == pygame.K_RIGHT:
                    print("坦克向右移动")
                    MainGame.my_tank.direction = "R"
                    MainGame.my_tank.remove = True
                elif event.key == pygame.K_UP:
                    print("坦克向上移动")
                    MainGame.my_tank.direction = "U"
                    MainGame.my_tank.remove = True
                elif event.key == pygame.K_DOWN:
                    print("坦克向下移动")
                    MainGame.my_tank.direction = "D"
                    MainGame.my_tank.remove = True
            if event.type == pygame.KEYUP and event.key in (pygame.K_UP, pygame.K_DOWN, pygame.K_RIGHT, pygame.K_RIGHT):
                MainGame.my_tank.remove = False

    def end_game(self):
        """
        结束游戏
        """
        print("谢谢使用！再见")
        exit()


if __name__ == "__main__":
    # 调用主窗口类
    MainGame().start_game()
