package com.itbaizhan.ajax.servlet;

import com.alibaba.fastjson.JSON;
import com.itbaizhan.ajax.pojo.User;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 用户管理servlet
 */
@WebServlet("/user.do")
public class UserServlet extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req,resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String flag = req.getParameter("flag");
        if(flag.equals("getData")){
            getData(req,resp);
        }else if(flag.equals("addUser")){
            addUser(req,resp);
        }else if(flag.equals("updateUser")){
            updateUser(req,resp);
        }
    }

    /**
     * 初始化用户数据
     * @throws ServletException
     */
    @Override
    public void init() throws ServletException {
        ArrayList<User> list = new ArrayList<>();
        User user1 = new User("1", "zhangsan", "111", "2020-02-04", 2000d);
        User user2 = new User("2", "lisi", "222", "2020-03-04", 3000d);
        User user3 = new User("3", "wangwu", "333", "2020-04-04", 4000d);
        User user4 = new User("4", "zhaoliu", "444", "2020-05-04", 5000d);
        User user5 = new User("5", "xiaoqi", "555", "2020-06-04", 2000d);
        list.add(user1);
        list.add(user2);
        list.add(user3);
        list.add(user4);
        list.add(user5);
        ServletContext servletContext = this.getServletContext();
        servletContext.setAttribute("list",list);

    }

    /**
     * 获取用户数据
     * @param request
     * @param resp
     */
    private void getData(HttpServletRequest request, HttpServletResponse resp) throws IOException {
        List<User> list = (List<User>)this.getServletContext().getAttribute("list");
        String s = JSON.toJSONString(list);
        resp.setContentType("application/json");
        PrintWriter writer = resp.getWriter();
        writer.println(s);
        writer.flush();
        writer.close();
    }

    /**
     * 更新用户
     * @param req
     * @param resp
     */
    private void updateUser(HttpServletRequest req, HttpServletResponse resp) throws IOException {
//        User user = this.createUser(req);
        String userid = req.getParameter("userid");
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        String salary = req.getParameter("salary");
        String birthday = req.getParameter("birthday");

        Double salaryDouble = Double.parseDouble(salary);
        System.out.println(salaryDouble);

        User user = new User();
        user.setId(userid);
        user.setUsername(username);
        user.setPassword(password);
//        user.setSalary(Double.parseDouble(salary));
        System.out.println(user);
//        ServletContext servletContext = this.getServletContext();
//        List<User> list = (List<User>)servletContext.getAttribute("list");
        //把list转成Map
//        Map<String, User> userMap = list.stream().collect(Collectors.toMap(User::getId, Function.identity()));
        //根据id查找对应的User对象
//        User user1 = userMap.get(user.getId());
//        list.remove(user1);
        //添加新的User对象
//        list.add(user);
        /*//按ID排序
        list.sort(new Comparator<User>() {
            @Override
            public int compare(User o1, User o2) {
                return Integer.parseInt(o1.getId())-Integer.parseInt(o2.getId());
            }
        });*/
        //输出到页面
        resp.setContentType("text/plain;charset=utf-8");
        PrintWriter writer = resp.getWriter();
        writer.println("更新成功");
        writer.flush();
        writer.close();
    }
    /**
     * 添加用户
     * @param req
     * @param resp
     */
    private void addUser(HttpServletRequest req,HttpServletResponse resp) throws IOException {
        User user = this.createUser(req);
        ServletContext servletContext = this.getServletContext();
        List<User> list = (List<User>)servletContext.getAttribute("list");
        list.add(user);
        resp.setContentType("text/plain;charset=utf-8");
        PrintWriter writer = resp.getWriter();
        writer.println("添加成功");
        writer.flush();
        writer.close();
    }

    /**
     * 返回一个用户对象
     * @param req
     * @return
     */
    private User createUser(HttpServletRequest req){

        String userid = req.getParameter("userid");
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        String salary = req.getParameter("salary");
        String birthday = req.getParameter("birthday");

        User user = new User();
        user.setId(userid);
        user.setUsername(username);
        user.setPassword(password);
        user.setSalary(Double.parseDouble(salary));
        user.setBirthday(birthday);

        return user;
    }
}

