package com.itbaizhan.ajax.servlet;

import com.alibaba.fastjson.JSON;
import com.itbaizhan.ajax.pojo.User;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/**
 * 用户管理servlet
 */
@WebServlet("/user.do")
public class UserServlet extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req,resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String flag = req.getParameter("flag");
        if(flag.equals("getData")){
            getData(req,resp);
        }
    }

    /**
     * 初始化用户数据
     * @throws ServletException
     */
    @Override
    public void init() throws ServletException {
        ArrayList<User> list = new ArrayList<>();
        User user1 = new User("1", "zhangsan", "111", "2020-02-04", 2000d);
        User user2 = new User("2", "lisi", "222", "2020-03-04", 3000d);
        User user3 = new User("3", "wangwu", "333", "2020-04-04", 4000d);
        User user4 = new User("4", "zhaoliu", "444", "2020-05-04", 5000d);
        User user5 = new User("5", "xiaoqi", "555", "2020-06-04", 2000d);
        list.add(user1);
        list.add(user2);
        list.add(user3);
        list.add(user4);
        list.add(user5);
        ServletContext servletContext = this.getServletContext();
        servletContext.setAttribute("list",list);

    }

    /**
     * 获取用户数据
     * @param request
     * @param resp
     */
    private void getData(HttpServletRequest request, HttpServletResponse resp) throws IOException {
        List<User> list = (List<User>)this.getServletContext().getAttribute("list");
        String s = JSON.toJSONString(list);
        resp.setContentType("application/json");
        PrintWriter writer = resp.getWriter();
        writer.println(s);
        writer.flush();
        writer.close();
    }
}
